(function() {
  //Farmerswife  4/06/2013
  var indexOf = [].indexOf;

  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'mobiscroll', 'models/event/EventModel', 'models/time/TimeModel', 'views/shared/ListView', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, Mobiscroll, EventModel, TimeModel, ListView) {
    var AddRequestView;
    return AddRequestView = class AddRequestView extends Backbone.View {
      initialize(usr, obj1, bs, dateSelected, eventsCol, type1) {
        var ref, ref1;
        this.usr = usr;
        this.obj = obj1;
        this.bs = bs;
        this.dateSelected = dateSelected;
        this.eventsCol = eventsCol;
        this.type = type1;
        if (this.type === 'Request') {
          this.taskList = this.bs.get('TaskName');
          if (!this.taskList) {
            this.taskList = (ref = this.bs.get(0)) != null ? ref.TaskName : void 0;
          }
        } else {
          this.taskList = this.bs.get("PersonnelType");
          if (!this.taskList) {
            this.taskList = (ref1 = this.bs.get(0)) != null ? ref1.PersonnelType : void 0;
          }
        }
        this.usePendingRequestReminderHours = this.usr.get('usePendingRequestReminderHours');
        if (this.usePendingRequestReminderHours) {
          this.defaultMaxApprovalTime = this.usr.get('pendingRequestReminderHours');
        } else {
          this.defaultMaxApprovalTime = 0;
        }
        return this.tm = new TimeModel();
      }

      events() {
        return {
          'tap #id-btn-back': 'btnBackClicked',
          'tap #id-btn-done-name': 'btnDoneNameClicked',
          //TABS
          'tap .btn-submenu-addrequest': 'subMenuAddReqClicked',
          //SHOWING FORM COMPONENTS
          'tap .edit-request-name': 'btnRequestNameClicked',
          //'tap .edit-request-date' : 'btnRequestDateClicked'
          'tap .edit-request-note': 'btnRequestNoteClicked',
          'tap .edit-max-approval-time': 'btnMaxApprovalTimeClicked',
          //SETTING DATE REQUEST
          'tap #btn-input-request-dayIn': 'btnRequestDateTimeClicked',
          'tap #btn-input-request-dayOut': 'btnRequestDateTimeClicked',
          'tap #btn-input-request-timeIn': 'btnRequestDateTimeClicked',
          'tap #btn-input-request-timeOut': 'btnRequestDateTimeClicked',
          'change .time': 'btnRequestDateTimeChanged',
          'change #id-slider-allDay': 'btnAllDayChanged',
          //SETTING REQUEST NAME
          'change input[name=radio-request]': 'btnRadioNameChanged',
          //SETTING REQUEST NOTE
          'tap #id-btn-done-note': 'btnDoneNoteClicked',
          'tap #id-btn-done-max-approval': 'btnDoneMaxApprovalClicked',
          //SAVING REQUEST
          'tap #id-btn-save-request': 'btnSaveRequestClicked',
          //POPUP CLOSE
          'tap .popUpDismiss': 'btnPopupClose',
          //ADD APPROVER
          'tap #id-btn-addInvolved': 'btnReqAddApproverClicked',
          'tap .btn-delete-involved': 'btnDeleteApproverClicked',
          'tap .edit-involved-extra-info': 'btnApproverExtraInfoClicked',
          'tap .popUpDismissAndBack': 'btnPopupCloseError'
        };
      }

      render() {
        var template;
        template = Handlebars.templates['AddRequestView'];
        this.$el.html(template({
          title: this.type,
          taskList: this.taskList,
          allDay: this.usr.get('defaultEventStartTime') ? false : true,
          mainDate: this.dateSelected.format("dddd Do MMMM"),
          year: this.dateSelected.format('YYYY'),
          humanDate: this.dateSelected.calendar(),
          defaultTimeIn: this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStartTime')),
          defaultTimeOut: this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStopTime')),
          daySelected: this.dateSelected.format('DD-MM-YYYY'),
          userMustSelectRequestType: this.usr.__must_select_request_type(),
          showRecipientUsersList: this.usr.__show_request_recipient_users_list(),
          recipientUsersList: this.__get_recipient_users_list(),
          defaultMaxApprovalTime: this.defaultMaxApprovalTime,
          usePendingRequestReminderHours: this.usePendingRequestReminderHours
        }));
        this.addSidePanel();
        return this.$el;
      }

      addSidePanel() {
        var MenuView;
        if (window.media_query_min_width(768)) {
          if (!MenuView) {
            MenuView = require("views/menu/MenuView");
          }
          this.panel = new MenuView(this.usr, this.obj);
          this.panel.render();
          return this.$el.append(this.panel.el);
        }
      }

      //SHOWING FORMS COMPONENTS
      btnRequestNoteClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return this.$el.find('.div-request-note-form').toggle();
      }

      btnMaxApprovalTimeClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return this.$el.find('.div-max-approval-form').toggle();
      }

      btnRequestNameClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return this.__go_to_name_form();
      }

      btnReqAddApproverClicked(event) {
        var nextView;
        event.stopPropagation();
        event.preventDefault();
        if (!ListView) {
          ListView = require('views/shared/ListView');
        }
        nextView = new ListView('Select Approver', 'Search Approvers...', this.usr, this.__get_recipient_users_list());
        return $.mobile.jqmNavigator.pushView(nextView, {
          transition: 'none'
        });
      }

      update_object_list(col) {
        var li, ulc;
        ulc = this.$el.find('#id-ul-objectMainBrowser');
        ulc.empty();
        if (col.length > 0) {
          _.each(col, (obj) => {
            var favClass, icon, isFav, li, name, objType;
            if (this.objectsCol.is_object_viewable(obj, this.context)) {
              if (obj.name) {
                isFav = this.__is_favorite(obj.objectID);
                favClass = 'nofavorite';
                if (isFav) {
                  favClass = '';
                }
                icon = this.__get_object_icon(obj);
                if (icon === 'fwi-object-browser') {
                  if (obj.type === "dayPlan") {
                    name = "(day-plan)";
                  } else {
                    name = "";
                  }
                  objType = 'objCls';
                  li = `<li data-objectServerType=\"${obj.type}\" data-objectLocalType=\"${objType}\" data-objectID=\"${obj.objectID}\" data-objectViewName=\"${obj.name}\" data-objectClassID=\"${obj.objectClassID}\" ><span class=\"fwi-obj-browser object-span\"/><span class='text-span'> ${obj.name} ${name}</span><span class=\"fwi-star favorite-span ${favClass}\"  /></li>`;
                } else if (icon === 'fwi-contact') {
                  objType = 'con';
                  li = `<li data-objectServerType=\"${obj.type}\" data-objectLocalType=\"${objType}\" data-objectID=\"${obj.objectID}\" data-objectViewName=\"${obj.name}\" data-objectClassID=\"${obj.objectClassID}\"  ><span class=\"fwi-contact object-span\"/><span class='text-span'> ${obj.name} </span><span class=\"fwi-star favorite-span ${favClass}\"  /></li>`;
                } else {
                  objType = 'obj';
                  li = `<li data-objectServerType=\"${obj.type}\" data-objectLocalType=\"${objType}\" data-objectID=\"${obj.objectID}\" data-objectClassID=\"${obj.objectClassID}\"  ><span class=\"fwi-obj object-span\"/><span class='text-span'> ${obj.name}</span><span class=\"fwi-star favorite-span ${favClass}\" /> </li>`;
                }
                return ulc.append(li);
              }
            }
          });
        } else {
          li = '<li>0 Objects found</li>';
          ulc.append(li);
        }
        this.$el.find('#id-spinner-all').hide();
        return ulc.listview('refresh');
      }

      //SETTING REQ DATES
      btnAllDayChanged(event) {
        var btn, status, time, timeIn, timeOut;
        btn = $(event.currentTarget);
        status = btn.val();
        if (status === 'on') { //SETTING ALL DAY TO EVERYTHING
          time = '00:00';
          $('#id-input-request-timeIn').val(time);
          $('#id-input-request-timeOut').val(time);
          $('#id-span-request-timeIn').text(time);
          $('#id-span-request-timeOut').text(time);
          $('#btn-input-request-timeIn').find('.ui-btn-text').html(time);
          $('#btn-input-request-timeOut').find('.ui-btn-text').html(time);
          $('#id-p-allDay').show();
          $('#id-p-times').hide();
          //HIDE TIMEIN /TIMEOUT
          return $('.timeButtons').hide();
        } else {
          //$('#btn-input-request-timeIn').hide()
          //$('#btn-input-request-timeOut').hide()
          timeIn = this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStartTime'));
          timeOut = this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStopTime'));
          $('#id-input-request-timeIn').val(timeIn);
          $('#id-input-request-timeOut').val(timeOut);
          $('#id-span-request-timeIn').text(timeIn);
          $('#id-span-request-timeOut').text(timeOut);
          $('#btn-input-request-timeIn').find('.ui-btn-text').html(timeIn);
          $('#btn-input-request-timeOut').find('.ui-btn-text').html(timeOut);
          $('#id-p-allDay').hide();
          $('#id-p-times').show();
          //SHOW TIMEIN /TIMEOUT
          return $('.timeButtons').show();
        }
      }

      //$('#btn-input-request-timeIn').show()
      //$('#btn-input-request-timeOut').show()
      btnRequestDateTimeClicked(event) {
        var curBtn, input, maxDate, options, timeOptions, type;
        event.stopPropagation();
        event.preventDefault();
        curBtn = $(event.currentTarget);
        input = curBtn.attr('data-target');
        type = curBtn.attr('data-type');
        maxDate = window.MAXDATE;
        if (this.usr.get('eventsBookableTimeFrameStop')) {
          maxDate = new Date(this.usr.get('eventsBookableTimeFrameStop'));
        }
        options = {
          theme: 'iOS',
          display: 'bottom',
          dateFormat: 'dd-mm-yy',
          dateOrder: 'ddmmyy',
          onChange: this.__validate,
          maxDate: maxDate
        };
        timeOptions = {
          theme: 'iOS',
          display: 'bottom',
          onChange: this.__validate
        };
        if (parseInt(this.usr.get('usesAMPM'), 10) === 0) {
          timeOptions['timeFormat'] = 'H:ii';
          timeOptions['timeWheels'] = 'Hii';
        } else {
          timeOptions['timeFormat'] = 'h:ii A';
          timeOptions['timeWheels'] = 'hii A';
        }
        switch (type) {
          case 'DI':
            $(input).mobiscroll().date(options);
            break;
          case 'TI':
            $(input).mobiscroll().time(timeOptions);
            break;
          case 'DO':
            $(input).mobiscroll().date(options);
            break;
          case 'TO':
            $(input).mobiscroll().time(timeOptions);
        }
        return $(input).mobiscroll('show');
      }

      btnRequestDateTimeChanged(event) {
        var btnTarget, dateIn, dateOut, formatStr, formatTime, gap, input, legend, newTo, popUp, popUpHtml, str, ti, to, type;
        //TODO SET TIME PICKER WITH BIGGER DATE INI > OUT    NOT CONSIDERING TIME&DAy ONLY DAY
        input = $(event.currentTarget);
        btnTarget = input.attr('data-target');
        type = $(btnTarget).attr('data-type');
        formatTime = 'h:mm A';
        if (parseInt(this.usr.get('usesAMPM'), 10) === 0) {
          formatTime = 'h:mm';
        }
        switch (type) {
          case 'TI':
            str = input.val();
            //# CHECK IF ITS IN SERVER LIMITS FOR STARTING TIME OR NOT
            gap = this.tm.get_float_from_time_string(this.usr.get('dayStartsAt'), str);
            if (gap < 0) {
              input.val(this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStartTime')));
              popUpHtml = `<div data-role="popup" id="popupAlert" data-overlay-theme="a" data-theme="c" data-dismissible="false" class="ui-corner-all">
<div data-role="header" data-theme="a" class="ui-corner-top">
<h3>Error With Your Initial Time</h3>
</div>
<div data-role="content" data-theme="d" class="ui-corner-bottom ui-content">
<p>You are adding a booking before your day starts, please check your Initial Time<p>
<a href="#" data-role="button" data-inline="true" data-rel="back" data-theme="c" class="popUpDismiss">Dismiss</a>
</div>
</div>`;
              this.$el.append(popUpHtml);
              popUp = this.$el.find('#popupAlert');
              popUp.popup();
              popUp.trigger('create');
              popUp.popup('open');
              return;
            }
            formatStr = 'H:mm';
            if (_.indexOf(str, 'M') !== -1) { //AMPM CHECK
              formatStr = 'h:mm A';
            }
            ti = Moment(input.val(), formatStr);
            to = Moment($('#id-input-request-timeOut').val(), formatStr);
            if (ti > to) {
              ti.add('m', 15);
              newTo = ti.format(formatStr);
              $('#id-input-request-timeOut').val(newTo); //SET TIME OUT INPUT
              $('#id-span-request-timeOut').text(newTo); //SET BLUE DIV
              $('#btn-input-request-timeOut').find('.ui-btn-text').html(newTo); //SET TIME OUT BUTTON
            }
            
            // SET TIME ON BLUE DIV
            $('#id-span-request-timeIn').text(str);
            if ($('#id-slider-allDay').val() === 'on') {
              $('#id-slider-allDay').val('off');
              $('#id-slider-allDay').trigger('change');
            }
            break;
          case 'DI':
            str = input.val();
            dateIn = Moment(input.val(), 'DD-MM-YYYY');
            dateOut = Moment($('#id-input-request-dayOut').val(), 'DD-MM-YYYY');
            if (dateIn > dateOut) {
              $('#id-input-request-dayOut').val(str);
              $('#id-input-request-dayOut').trigger('change');
            }
            // SET TIME ON BLUE DIV
            $('.main-date strong').text(dateIn.format("dddd Do MMMM"));
            $('.year').text(dateIn.format("YYYY"));
            $('.human-date').text(dateIn.calendar());
            legend = dateIn.format('dddd Do MMMM') + ' - ' + dateOut.format('dddd Do MMMM') + ' (1/' + (dateOut.diff(dateIn, 'days') + 1) + ')';
            //SET TIME LEGEND IF NEEDED
            if (dateOut.diff(dateIn, 'days') > 0) {
              $('#id-p-request-legend').text(legend);
            } else {
              $('#id-p-request-legend').text('');
            }
            break;
          case 'TO':
            str = input.val();
            //          strOut = $('#id-input-request-dayOut').val()+' '+input.val()
            //          strIn = $('#id-input-request-dayIn').val()+' '+$('#id-input-request-timeIn').val()
            //          dateOut = Moment(strOut,'DD-MM-YYYY hh:mm')
            //          dateIn = Moment(strIn,'DD-MM-YYYY hh:mm')
            //          if dateOut < dateIn
            //            #console.log 'WRONNNNNG '
            // SET TIME ON BLUE DIV
            $('#id-span-request-timeOut').text(str);
            if ($('#id-slider-allDay').val() === 'on') {
              $('#id-slider-allDay').val('off');
              $('#id-slider-allDay').trigger('change');
            }
            break;
          case 'DO':
            str = input.val();
            dateIn = Moment($('#id-input-request-dayIn').val(), 'DD-MM-YYYY');
            dateOut = Moment(input.val(), 'DD-MM-YYYY');
            legend = dateIn.format('dddd Do MMMM') + ' - ' + dateOut.format('dddd Do MMMM') + ' (1/' + (dateOut.diff(dateIn, 'days') + 1) + ')';
            // SET TIME LEGEND
            if (dateOut.diff(dateIn, 'days') > 0) {
              $('#id-p-request-legend').text(legend);
            } else {
              $('#id-p-request-legend').text('');
            }
        }
        return $(btnTarget).find('.ui-btn-text').html(str);
      }

      listItemSelected(view, objMdl) {
        view.print_li_approvers(false, objMdl);
        //COMING BACK TO TASK VIEW FROM OBJECT BRWOSER
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      //APPROVERS TAB
      print_li_approvers(myself, obj) {
        var group, groups, icon, id, li, name, ref, resp_groups, ul;
        if (typeof obj === 'undefined') {
          return;
        }
        name = obj.get('userName');
        id = obj.get('userID');
        icon = 'fwi-contact';
        resp_groups = (ref = this.bs.get(0)) != null ? ref.RequestGroup : void 0;
        groups = [];
        if (resp_groups !== void 0 && resp_groups !== null) {
          if (resp_groups instanceof Array) {
            groups = resp_groups;
          } else {
            groups = [resp_groups];
          }
        }
        if (indexOf.call((function() {
          var i, len, results;
          results = [];
          for (i = 0, len = groups.length; i < len; i++) {
            group = groups[i];
            results.push(group.groupID);
          }
          return results;
        })(), id) >= 0) {
          icon = 'fwi-object-browser';
        }
        li = `<li class=\"liBookingInvolved\" data-userID=\"${id}\"  data-userName=\"${name}\">`;
        li += `<div class='header edit-involved-extra-info'><span class=\"name ${icon}\" > ${name} </span><span class='fwi-edit'/> </div>`;
        li += '<div class="extra-info" style="display: none;">';
        li += '<div class="div-wrap"><span class="btn btn-delete-involved"> Delete Approver</span></div>';
        li += '</div></li>';
        ul = $('#id-ul-task-involved');
        ul.append(li);
        $('.extra-info').trigger('create');
        ul.listview();
        return ul.listview('refresh');
      }

      btnDeleteApproverClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return $(event.currentTarget).parents('li').remove();
      }

      __validate(date, inst) {
        var dateIn, dateOut, instOut, timeInstOut;
        //dayIn  = $('#id-input-request-dayIn').mobiscroll('getInst')
        instOut = $('#id-input-request-dayOut').mobiscroll('getInst');
        timeInstOut = $('#id-input-request-timeOut').mobiscroll('getInst');
        if (instOut != null ? instOut.isVisible() : void 0) {
          if (_.indexOf($('#id-input-request-timeOut').val(), 'M') === -1) {
            dateOut = Moment(date + ' ' + $('#id-input-request-timeOut').val(), 'DD-MM-YYYY h:mm');
            dateIn = Moment($('#id-input-request-dayIn').val() + ' ' + $('#id-input-request-timeIn').val(), 'DD-MM-YYYY h:mm');
          } else {
            dateOut = Moment(date + ' ' + $('#id-input-request-timeOut').val(), 'DD-MM-YYYY h:mm A');
            dateIn = Moment($('#id-input-request-dayIn').val() + ' ' + $('#id-input-request-timeIn').val(), 'DD-MM-YYYY h:mm A');
          }
          if (dateIn > dateOut) {
            $('.dwv').html('<strong>Ini Day > End Day</strong>');
            $('.dwbw.dwb-s').hide();
          } else {
            $('.dwbw.dwb-s').show();
            return;
          }
        }
        if (timeInstOut != null ? timeInstOut.isVisible() : void 0) {
          if (_.indexOf(timeInstOut.val, 'M') === -1) {
            dateOut = Moment(date, 'H:mm');
            dateIn = Moment($('#id-input-request-timeIn').val(), 'H:mm');
          } else {
            dateOut = Moment(date, 'h:mm A');
            dateIn = Moment($('#id-input-request-timeIn').val(), 'h:mm A');
          }
          if (dateIn > dateOut) {
            $('.dwv').html('<strong>Ini Date > End Date</strong>');
            return $('.dwbw.dwb-s').hide();
          } else {
            $('.dwbw.dwb-s').show();
          }
        }
      }

      //SETTING REQ NOTE
      btnDoneNoteClicked(event) {
        var reqNote;
        event.stopPropagation();
        event.preventDefault();
        reqNote = $('#id-input-request-note').val();
        this.$el.find('p.edit-request-note').text(reqNote);
        return this.$el.find('.div-request-note-form').hide();
      }

      //SETTING REQ MAX APPROVAL TIME
      btnDoneMaxApprovalClicked(event) {
        var maxApproval;
        event.stopPropagation();
        event.preventDefault();
        maxApproval = $('#id-input-max-approval').val();
        this.$el.find('p.edit-max-approval-time').text(maxApproval);
        return this.$el.find('.div-max-approval-form').hide();
      }

      //SETTING REQ NAME
      btnRadioNameChanged(event) {
        var radio, reqName;
        event.stopPropagation();
        event.preventDefault();
        radio = $(event.currentTarget);
        reqName = radio.val();
        $('p.edit-request-name').text(reqName);
        $('#id-input-request-name').val(reqName);
        $('#id-input-request-name').attr('data-personnelTypeNumber', radio.attr('data-personnelTypeNumber'));
        return this.__go_to_request_form();
      }

      btnDoneNameClicked(event) {
        var input, reqName;
        event.stopPropagation();
        event.preventDefault();
        input = $('#id-input-request-name');
        reqName = input.val();
        $('p.edit-request-name').text(reqName);
        return this.__go_to_request_form();
      }

      //SAVING REQ
      btnSaveRequestClicked(event) {
        var cur, dateIn, dateOut, diffDays, popUp, popUpHtml, request;
        event.stopPropagation();
        event.preventDefault();
        request = new Object();
        request.sessionID = this.usr.get('sessionID');
        if (this.type === 'Request') {
          request.parentType = 'request';
        } else {
          request.parentType = 'personnel';
          request.personnelTypeNumber = $('#id-input-request-name').attr('data-personnelTypeNumber');
          request.bookingLineID = this.usr.get('usersObjectID');
        }
        //DAY
        request.day = Moment($('#id-input-request-dayIn').val(), 'DD-MM-YYYY').format('YYYY-MM-DD'); //$('#id-input-request-dayIn').val()
        if ($('#id-slider-allDay').val() === 'on') {
          request.timeIn = 0.0;
          request.timeOut = 24.0;
          request.allDay = 1;
        } else {
          //TIME IN  FLOAT
          request.timeIn = this.tm.get_float_from_time_string(parseInt(this.usr.get('dayStartsAt'), 10), $('#id-input-request-timeIn').val());
          //TIME OUT FLOAT
          request.timeOut = this.tm.get_float_from_time_string(parseInt(this.usr.get('dayStartsAt'), 10), $('#id-input-request-timeOut').val());
        }
        //OCUR DAYS
        dateIn = Moment($('#id-input-request-dayIn').val(), 'DD-MM-YYYY');
        dateOut = Moment($('#id-input-request-dayOut').val(), 'DD-MM-YYYY');
        diffDays = dateOut.diff(dateIn, 'days');
        if (diffDays > 0) {
          request.occursOnDay = [];
          cur = dateIn;
          while (cur <= dateOut) {
            request.occursOnDay.push(cur.format('YYYY-MM-DD'));
            cur.add('days', 1);
          }
        } else {
          request.occursOnDay = dateIn.format('YYYY-MM-DD');
        }
        //REQ NAME
        request.name = $('#id-input-request-name').val();
        //REQ NOTE
        request.note = $('#id-input-request-note').val() ? $('#id-input-request-note').val() : "";
        //NEW
        request.bookingID = 'new';
        request.maxApprovalTime = $('#id-input-max-approval').val() ? $('#id-input-max-approval').val() : this.defaultMaxApprovalTime;
        //REQUEST USERS
        request.requestUsers = new Array();
        _.each($('.liBookingInvolved'), (liInv) => {
          var group, groups, ref, resp_groups, userID;
          userID = window.__check_undefined($(liInv).attr('data-userID'));
          resp_groups = (ref = this.bs.get(0)) != null ? ref.RequestGroup : void 0;
          groups = [];
          if (resp_groups !== void 0 && resp_groups !== null) {
            if (resp_groups instanceof Array) {
              groups = resp_groups;
            } else {
              groups = [resp_groups];
            }
          }
          if (indexOf.call((function() {
            var i, len, results;
            results = [];
            for (i = 0, len = groups.length; i < len; i++) {
              group = groups[i];
              results.push(group.groupID);
            }
            return results;
          })(), userID) < 0) {
            return request.requestUsers.push(userID);
          }
        });
        //REQUEST GROUPS
        request.requestGroups = new Array();
        _.each($('.liBookingInvolved'), (liInv) => {
          var group, groups, ref, resp_groups, userID;
          userID = window.__check_undefined($(liInv).attr('data-userID'));
          resp_groups = (ref = this.bs.get(0)) != null ? ref.RequestGroup : void 0;
          groups = [];
          if (resp_groups !== void 0 && resp_groups !== null) {
            if (resp_groups instanceof Array) {
              groups = resp_groups;
            } else {
              groups = [resp_groups];
            }
          }
          if (indexOf.call((function() {
            var i, len, results;
            results = [];
            for (i = 0, len = groups.length; i < len; i++) {
              group = groups[i];
              results.push(group.groupID);
            }
            return results;
          })(), userID) >= 0) {
            return request.requestGroups.push(userID);
          }
        });
        if (this.usr.__show_request_recipient_users_list() && request.requestUsers.length === 0 && request.requestGroups.length === 0) {
          popUpHtml = " <div data-role=\"popup\" id=\"popupAlert\" data-overlay-theme=\"a\" data-theme=\"c\" class=\"ui-corner-all centered\"> <div data-role=\"header\" data-theme=\"a\" class=\"ui-corner-top\"> <h3>Warning saving request</h3> </div> <div data-role=\"content\" data-theme=\"d\" class=\"ui-corner-bottom ui-content\" style=\"margin-left: 0;\"> <p>Please select at least one approver.</p> <a href=\"#\" data-role=\"button\" data-inline=\"true\" data-rel=\"back\" data-theme=\"c\" class=\"popUpDismiss\">Dismiss</a> </div> </div>";
          this.$el.append(popUpHtml);
          popUp = this.$el.find('#popupAlert');
          popUp.popup();
          popUp.trigger('create');
          popUp.popup('open');
          return;
        }
        event = new EventModel();
        event.on('change', this.__refresh_and_change_page, this);
        return event.save_request(request);
      }

      subMenuAddReqClicked(event) {
        var btn, id;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        if (!btn.hasClass('ui-disabled')) {
          id = btn.attr('data-target');
          this.$el.find('.subAddReqView').hide();
          return $(id).show();
        }
      }

      btnApproverExtraInfoClicked(event) {
        var ref;
        event.stopPropagation();
        event.preventDefault();
        // EXTRA INFO ICON
        if (((ref = this.$(event.currentTarget).find('.fwi-edit')) != null ? ref.length : void 0) > 0) {
          this.$(event.currentTarget).find('.fwi-edit').addClass('fwi-cross-cancel').removeClass('fwi-edit');
        } else {
          this.$(event.currentTarget).find('.fwi-cross-cancel').addClass('fwi-edit').removeClass('fwi-cross-cancel');
        }
        //SHOW/HIDE FORM  Extra INFO
        return this.$(event.currentTarget).parent().find('.extra-info').toggle();
      }

      __refresh_and_change_page(event) {
        var conflict, error, isError, popUp, popUpHtml;
        isError = event.get('isError');
        if (isError === 1) {
          error = event.get('error');
          popUpHtml = '<div data-role="popup" id="popupAlert" data-overlay-theme="a" data-theme="c" class="ui-corner-all"> <div data-role="header" data-theme="a" class="ui-corner-top"> <h3>Error saving Request</h3> </div> <div data-role="content" data-theme="d" class="ui-corner-bottom ui-content">';
          popUpHtml += `<p>${error}</p>`;
          popUpHtml += '<a href="#" data-role="button" data-inline="true" data-rel="back" data-theme="c" class="popUpDismissAndBack">Dismiss</a> </div></div>';
          this.$el.append(popUpHtml);
          popUp = this.$el.find('#popupAlert');
          popUp.popup();
          popUp.trigger('create');
          return popUp.popup('open');
        } else if (event.get('EventCommitConflicts')) {
          conflict = event.get('EventCommitConflicts');
          popUpHtml = '<div data-role="popup" id="popupAlert" data-overlay-theme="a" data-theme="c" class="ui-corner-all"> <div data-role="header" data-theme="a" class="ui-corner-top"> <h3>Error saving Personnel Booking</h3> </div> <div data-role="content" data-theme="d" class="ui-corner-bottom ui-content">';
          popUpHtml += `<p>${conflict.header}</p><p>Conflicts with: ${conflict.Conflict.header} on day: ${conflict.Conflict.day}</p>`;
          popUpHtml += '<a href="#" data-role="button" data-inline="true" data-rel="back" data-theme="c" class="popUpDismiss">Dismiss</a> </div></div>';
          this.$el.append(popUpHtml);
          popUp = this.$el.find('#popupAlert');
          popUp.popup();
          popUp.trigger('create');
          return popUp.popup('open');
        } else {
          return this.__change_page(event);
        }
      }

      __change_page(event) {
        var firstDay, found, i, index, len, ref, ref1, view;
        firstDay = Moment(this.$el.find('#id-input-request-dayIn').val(), 'DD-MM-YYYY');
        if (!this.obj) {
          this.eventsCol.set_day_events(this.usr, firstDay);
          return $.mobile.jqmNavigator.popToFirst({
            transition: 'none'
          });
        } else {
          this.eventsCol.set_day_events(this.usr, firstDay, this.obj);
          index = 0;
          found = false;
          ref = $.mobile.jqmNavigator.getViews();
          for (i = 0, len = ref.length; i < len; i++) {
            view = ref[i];
            if ((ref1 = $(view.el).attr('id')) === 'id-EventListView' || ref1 === 'id-EventSheetView' || ref1 === 'id-EventDayPlan') {
              found = true;
              break;
            }
            index++;
          }
          if (!found) {
            index = 0;
          }
          return $.mobile.jqmNavigator.popToView(index, {
            transition: 'none'
          });
        }
      }

      //BACk BUTTON
      btnBackClicked() {
        event.stopPropagation();
        event.preventDefault();
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      btnPopupClose(event) {
        return this.$el.find('#popupAlert').remove();
      }

      btnPopupCloseError(event) {
        this.$el.find('#popupAlert').remove();
        return this.__change_page(this.event);
      }

      __get_recipient_users_list() {
        var group, groups, i, len, recipients, ref, ref1, resp_groups, users;
        resp_groups = (ref = this.bs.get(0)) != null ? ref.RequestGroup : void 0;
        groups = [];
        if (resp_groups !== void 0 && resp_groups !== null) {
          if (resp_groups instanceof Array) {
            groups = resp_groups;
          } else {
            groups = [resp_groups];
          }
        }
        users = (ref1 = this.bs.get(0)) != null ? ref1.RequestUser : void 0;
        recipients = [];
        if (users !== void 0) {
          recipients = [...users];
        }
        for (i = 0, len = groups.length; i < len; i++) {
          group = groups[i];
          recipients.push({
            userID: group.groupID,
            userName: group.groupName
          });
        }
        return recipients;
      }

      //HELPERS FOR REQUEST NAME FORM
      __go_to_request_form(params) {
        $('#id-namerequest-form').hide();
        $('.form-request-component').hide();
        $('#id-addrequest-form').show();
        //BUTTONS CONTROL
        $('#id-btn-done-name').hide();
        return $('#id-btn-save-request').show();
      }

      __go_to_name_form(params) {
        $('#id-addrequest-form').hide();
        $('#id-namerequest-form').show();
        //BUTTONS CONTROL
        $('#id-btn-done-name').show();
        return $('#id-btn-save-request').hide();
      }

    };
  });

}).call(this);
